/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.api.scoreboards.display.formatters.styling;

import java.util.Collections;
import java.util.PrimitiveIterator;
import net.impactdev.impactor.api.scoreboards.display.formatters.DisplayFormatter;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;

public abstract class ColorFormatter
implements DisplayFormatter.Stateful {
    @Override
    public Component format(Component root) {
        int length = PlainTextComponentSerializer.plainText().serialize(root).length();
        return this.apply(root, length);
    }

    protected abstract void advance(int var1);

    protected abstract TextColor color(int var1);

    private Component apply(Component component, int totalSize) {
        if (component instanceof TextComponent) {
            TextComponent text = (TextComponent)component;
            if (text.style().color() != null) {
                String content = text.content();
                int length = content.codePointCount(0, content.length());
                for (int i = 0; i < length; ++i) {
                    this.advance(totalSize);
                }
                Component result = text.children(Collections.emptyList());
                for (Component child : text.children()) {
                    result = result.append(this.apply(child, totalSize));
                }
                return result;
            }
            String content = text.content();
            if (!content.isEmpty()) {
                TextComponent.Builder parent = Component.text();
                int[] holder = new int[1];
                PrimitiveIterator.OfInt it = content.codePoints().iterator();
                while (it.hasNext()) {
                    holder[0] = it.nextInt();
                    TextComponent letter = Component.text((String)new String(holder, 0, 1), (Style)component.style().color(this.color(totalSize)));
                    this.advance(totalSize);
                    parent.append((Component)letter);
                }
                BuildableComponent result = parent.build();
                for (Component child : component.children()) {
                    result = result.append(this.apply(child, totalSize));
                }
                return result;
            }
        } else {
            Component other = component.children(Collections.emptyList()).colorIfAbsent(this.color(totalSize));
            this.advance(totalSize);
            for (Component child : component.children()) {
                other = other.append(this.apply(child, totalSize));
            }
            return other;
        }
        return Component.empty().mergeStyle(component);
    }
}

